﻿using Microsoft.SharePoint.Client;

namespace SecuringObjects
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         Web web = ctx.Web;
         List orders = web.Lists.GetByTitle("Bestellungen");

         // Berechtigungsvererbung aufbrechen und keine ACLs kopieren
         orders.BreakRoleInheritance(false, true);

         // Auf ein bestehendes Benutzerobjekt zugreifen
         User user = web.EnsureUser(@"CONTOSO\EgonS");

         // Collection von Rollendefinitionen erzeugen
         RoleDefinitionBindingCollection roleDefinitions =
            new RoleDefinitionBindingCollection(ctx);

         // Rolle "Lesen" der Collection hinzufügen
         roleDefinitions.Add(web.RoleDefinitions.GetByType(RoleType.Reader));

         // Benutzer für die Liste berechtigen
         orders.RoleAssignments.Add(user, roleDefinitions);

         ctx.ExecuteQuery();
      }
   }
}